/*
Code for task1 - laboratory exercise 6
Jiri J, 2024
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/** 
 * @brief Structure to store a contact's details.
 */
typedef struct{
	char name[100];
	int age;
} contact;


/**
 * @brief Reads a new contact's details from the given file stream and adds it to
 * the list of contacts. Reallocates memory for the contact list if successful.
 *
 * @param pFile Pointer to the stream to read from (`stdin` for user input).
 * @param contacts Pointer to the dynamically allocated array of contacts.
 * @param num_contacts Pointer to the count of contacts, updated if the new contact is added.
 *
 * @return `0` if successful, `-1` if input is invalid or EOF, `-2` if memory allocation fails.
 */
int add_contact(FILE* pFile, contact** contacts, int* num_contacts){
	contact new_contact;
	
	// read name
	if (fgets(new_contact.name, sizeof(new_contact.name), pFile) == NULL){
		return -1;
	}
	// remove new line (if any)
	new_contact.name[strcspn(new_contact.name, "\n")] = '\0';
	
	
	// read user input - age
	if (fscanf(pFile, "%d\n", &new_contact.age) != 1){
		return -1;
	}

	// realloc the array
	(*contacts) = (contact*) realloc(*contacts, (*num_contacts + 1) * sizeof(contact));
	if (*contacts == NULL){
		printf("Allocation error\n");
		return -2;
	}
	
	// add new contact
	(*contacts)[*num_contacts] = new_contact;
	(*num_contacts)++;
	
	return 0;
}


/**
 * @brief Prints all stored contacts, displaying the name and age of each.
 * 
 * @param contacts Array of contact structures to display.
 * @param num_contacts Number of contacts stored in the array.
 */
void print_contacts(contact* contacts, int num_contacts){
	printf("----------------------------------------\n");
	for (int i = 0; i < num_contacts; i++) {
		printf("===User %d===\n", i);
		printf("Name: %s\n", contacts[i].name);
		printf("Age: %d\n", contacts[i].age);
	}
	printf("----------------------------------------\n");
}


int main(int argc, char* argv[]){

	// init variables
	contact* contacts = NULL;
	int num_contacts = 0;
	int key;
	int exit = 0;
	FILE *pFile;
	
	// open a file called people.txt in READ mode
	pFile = fopen("people.txt", "r");
	
	// if opening failed exit
	if(pFile == NULL){
		printf("Failed to open file\n");
		return -1;
	// otherwise read all contacts
	}else{
		while(1){
			int ret = add_contact(pFile, &contacts, &num_contacts);
			if (ret == -1){
				break;
			}else if(ret == -2){
				free(contacts);
				return -1;
			}
		}
		// close file
		fclose(pFile);
	}
	
	// print all contacts
	print_contacts(contacts, num_contacts);
	
	// free allocated memory
	free(contacts);

	return 0;
}
