#pragma once

#include "CoreMinimal.h"

class FClothNode;
typedef TSharedRef<FClothNode> FClothNodeRef;

/**
 * Class representing a spring between two cloth nodes. The spring has resting length (specified
 * by the distance between the connected cloth nodes on creation of the spring) and parameters
 * defining its elasticity and damping.
 */
class CVICENI6_API FClothSpring
{
public:
	FClothSpring(const FClothNodeRef First, const FClothNodeRef Second, const float Elasticity, const float DampingFactor);

	~FClothSpring() {}

	// Use computed acting force of the spring from GetActingForce to modify the connected
	// cloth nodes, adding the acting force symmetrically to both of them.
	void AddForceToNodes() const;

private:

	// Compute the force of this particular spring. Depends on the spring's elasticity, rest length
	// and damping factor. Since the string is always connected to two cloth nodes, its tension
	// also depends on their distance.
	FVector GetActingForce() const;
	
	FClothNodeRef First;
	FClothNodeRef Second;
	double Elasticity;
	double DampingFactor;
	double RestLength;
};
