#pragma once

#include "CoreMinimal.h"
#include "ClothNode.h"
#include "ClothSpring.h"
#include "Components/ActorComponent.h"
#include "ClothSimulationComponent.generated.h"

DECLARE_LOG_CATEGORY_EXTERN(ClothSimulationComponent, All, All);

UCLASS( ClassGroup=(Custom), meta=(BlueprintSpawnableComponent) )
class CVICENI6_API UClothSimulationComponent : public UActorComponent
{
	GENERATED_BODY()

public:	
	// Sets default values for this component's properties
	UClothSimulationComponent();

	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="Cloth Simulation")
	double NodeMass = 0.1f;

	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="Cloth Simulation")
	double StructuralElasticity = 1.0f;

	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="Cloth Simulation")
	double ShearElasticity = 1.0f;

	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="Cloth Simulation")
	double BendElasticity = 1.0f;

	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="Cloth Simulation")
	double Damping = 1.0f;

	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="Cloth Simulation")
	float TimeScale = 1.0f;

	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="Cloth Simulation")
	bool bUseConstantTimeStep = false;

	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="Cloth Simulation")
	float ConstantTimeStep = 1.0f / 90.0f;
	
	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="Cloth Simulation")
	float Scale = 100.0f;

	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="Cloth Simulation")
	int32 GridSize = 10;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="Cloth Simulation")
	FVector WindForce = FVector::ZeroVector;

protected:
	// Called when the game starts
	virtual void BeginPlay() override;

public:	
	// Called every frame
	virtual void TickComponent(float DeltaTime, ELevelTick TickType, FActorComponentTickFunction* ThisTickFunction) override;

	bool HasValidParameters();
	void GenerateCloth();
	void StartConstantTimer();

	FVector GetNodePosition(int32 NodeIndex) const;

private:
	TArray<FClothNodeRef> ClothNodes;
	TArray<FClothSpringRef> ClothSprings;
	FTimerHandle TimerHandle;

	void TickSimulation(float DeltaTime);

	inline int NodeIndex(int X, int Y) const;
};
