#include "ClothSpring.h"
#include "ClothNode.h"

FClothSpring::FClothSpring(const FClothNodeRef First, const FClothNodeRef Second, const float Elasticity,
	const float DampingFactor)
		: First(First), Second(Second), Elasticity(Elasticity), DampingFactor(DampingFactor)
{
	RestLength = FVector::Distance(First->GetPosition(), Second->GetPosition());
}

void FClothSpring::AddForceToNodes() const
{
	// We have two connected nodes - First and Second.
	// TODO: Compute the force acting between them as a result of this spring (using GetActingForce),
	// TODO: then add the force symmetrically to both nodes.
}

FVector FClothSpring::GetActingForce() const
{
	// We need to compute the force with which this spring is acting.
	// For that purpose, we can use GetPosition and GetSpeed on each of our cloth nodes (First and Second)
	// and then do the calculation using the spring's parameters (fields DampingFactor, Elasticity and RestLength)

	// TODO: Compute and return the spring's acting force (both the elastic component and the damping component)

	return FVector::ZeroVector;
}
