#pragma once

#include "CoreMinimal.h"
#include "GameFramework/Actor.h"
#include "Engine/StaticMeshActor.h"
#include "NewtonParticleSystem.generated.h"


UCLASS()
class CVICENI4_API ANewtonParticleSystem : public AActor
{
	GENERATED_BODY()
	
public:	
	// Sets default values for this actor's properties
	ANewtonParticleSystem();

	// How many particles to generate in BeginPlay
	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="Newton Particles")
	int32 ParticleCount = 100;

	// How far the particles can be generated in BeginPlay
	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="Newton Particles")
	float InitialSpread = 500.0f;

	// What is the mass of each particle in Kg
	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="Newton Particles")
	float ParticleMass = 1000.0f;

	// The gravitational constant used as a factor of the gravitational force.
	// We use a value higher than reality to better show the simulation at smaller mass values.
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="Newton Particles")
	float GravitationalConstant = 10.0f;
	
	// Whether to use the ParallelFor construct
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="Newton Particles")
	bool UseParallelFor = false;

	// The class of the particle to spawn in BeginPlay
	UPROPERTY(EditAnywhere, Category="Newton Particles")
	TSubclassOf<AStaticMeshActor> ParticleClass;

protected:
	// Called when the game starts or when spawned
	virtual void BeginPlay() override;
	
	// Returns the force acting upon the specified particle
	// based on all the other existing particles.
	FVector ComputeParticleForce(uint32 ParticleIndex) const;
	
	// Keeps track of all our spawned particles
	UPROPERTY()
	TArray<AStaticMeshActor*> Particles;

public:	
	// Called every frame
	virtual void Tick(float DeltaTime) override;

};
