#pragma once

#include "CoreMinimal.h"
#include "Engine/StaticMeshActor.h"
#include "GameFramework/Actor.h"
#include "Brick.generated.h"

UCLASS()
class CVICENI4_API ABrick : public AStaticMeshActor
{
	GENERATED_BODY()
	
public:	
	// Sets default values for this actor's properties
	ABrick();
	
	// To make an example and also to skip specifying the acting location
	// for the force, the two following methods are separate instead of
	// being a single method with two arguments.
	UFUNCTION(BlueprintCallable, Category="Brick")
	void ApplyLeftForce(float Scale);

	UFUNCTION(BlueprintCallable, Category="Brick")
	void ApplyRightForce(float Scale);

protected:
	// Called when the game starts or when spawned
	virtual void BeginPlay() override;

	void ApplyForce(float Scale, FVector Location);

	// Helper reference to an arrow we can easily display so visualize
	// where a force has been added using the above method.
	TSubclassOf<AActor> ArrowClass;
public:	
	// Called every frame
	virtual void Tick(float DeltaTime) override;
};
