#pragma once

#include "CoreMinimal.h"
#include "Engine/StaticMeshActor.h"
#include "PressurePlate.generated.h"

DECLARE_LOG_CATEGORY_EXTERN(PressurePlate, All, All);


/**
 * A simple class representing a block that can be stepped on. Doing so (or otherwise just colliding with the block)
 * will trigger the coded action (method OnPressed).
 */
UCLASS()
class CVICENI3_API APressurePlate : public AStaticMeshActor
{
	GENERATED_BODY()

public:
	APressurePlate();

	virtual void BeginPlay() override;
	virtual void Tick(float DeltaSeconds) override;

	// If we want to use a function for event callbacks, it has to be marked with the UFUNCTION macro to be included
	// in Unreal's reflection data.
	UFUNCTION()
	void OnPressed(UPrimitiveComponent* HitComponent, AActor* OtherActor, UPrimitiveComponent* OtherComp, FVector NormalImpulse, const FHitResult& Hit);

	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	TSubclassOf<AActor> BoulderClass;

	UPROPERTY(VisibleAnywhere, BlueprintReadOnly)
	bool bSuppressPressed = false;
};
