#include "BTTask_SelectRandomObject.h"

#include "EngineUtils.h"
#include "BehaviorTree/BlackboardComponent.h"
#include "Kismet/GameplayStatics.h"


UBTTask_SelectRandomObject::UBTTask_SelectRandomObject(const FObjectInitializer& ObjectInitializer) : Super(ObjectInitializer)
{
	NodeName = "Select Random Object";
	INIT_TASK_NODE_NOTIFY_FLAGS();

	// Set filters for our blackboard keys
	LocationBlackboardKey.AddVectorFilter(this, GET_MEMBER_NAME_CHECKED(UBTTask_SelectRandomObject, LocationBlackboardKey));
	ObjectBlackboardKey.AddObjectFilter(this, GET_MEMBER_NAME_CHECKED(UBTTask_SelectRandomObject, ObjectBlackboardKey), TargetClass);
}

EBTNodeResult::Type UBTTask_SelectRandomObject::ExecuteTask(UBehaviorTreeComponent& OwnerComp, uint8* NodeMemory)
{
	AActor* Result = nullptr;
	TArray<AActor*> Actors;
	UGameplayStatics::GetAllActorsOfClass(OwnerComp.GetWorld(), TargetClass, Actors);
	if (Actors.Num() == 0)
			return EBTNodeResult::Failed;
	
	int index = FMath::RandRange(0, Actors.Num() - 1);
	Result = Actors[index];

	if (Result == nullptr)
		return EBTNodeResult::Failed;
	
	UBlackboardComponent* BlackboardComponent = OwnerComp.GetBlackboardComponent();
	BlackboardComponent->SetValueAsObject(ObjectBlackboardKey.SelectedKeyName, Result);
	BlackboardComponent->SetValueAsVector(LocationBlackboardKey.SelectedKeyName, Result->GetActorLocation());
		
	return EBTNodeResult::Succeeded;
}
