#include <stdio.h>
#include <time.h>
#include "EasyBMP.h"
#include <omp.h>

#define INPUT_IMAGE  "Vit.bmp"
#define OUTPUT_IMAGE "Vit_zaostrenej.bmp"

using namespace std;

void Sharpen( BMP& From, BMP& To);

int main( int argc, char* argv[] )
{
  struct timespec start, stop;
  double elapsed;
  
  cout << endl
       << " Cteni zdrojoveho souboru..." << endl;

  BMP Background;
  Background.ReadFromFile(INPUT_IMAGE);

  BMP Output;
  Output.SetSize( Background.TellWidth() , Background.TellHeight() );
  Output.SetBitDepth( 24 );

  //------------------------------
  clock_gettime(CLOCK_REALTIME, &start);
  Sharpen(Background,Output);
  clock_gettime(CLOCK_REALTIME, &stop);
  //------------------------------

  cout << " Zapis zaostreneho obrazu do souboru..." << endl;
  Output.WriteToFile(OUTPUT_IMAGE);

  elapsed = ( stop.tv_sec - start.tv_sec )*1000
             + (double)( stop.tv_nsec - start.tv_nsec )/(double)1000000;
  cout << " Beh sledovane casti programu trval: "
       << elapsed << " ms" << endl;


  return 0;
}

//-----------------------------------------------------------------------------
void Sharpen( BMP& From, BMP& To)
{
    const int PositionT = 0;
	const int PositionL = 0;
	int PositionR = From.TellWidth()-1;
	int PositionB = From.TellHeight()-1;

    RGBApixel PixelT, PixelB, PixelR, PixelL, PixelC, NewPixel;
    int tmp;
    int Mult = 5;
	int i,j,k;
    
	// overeni zhody velikosti bitmap:
	if( To.TellWidth() != From.TellWidth() || To.TellHeight() != From.TellHeight())
		{ cout << " Error: 0" << endl; return; }

	// skopirovani okraje bitmapy:
	for( j=PositionT ; j <= PositionB ; j++ )
	{
		PixelToPixelCopy( From, 0, j, To, 0, j);
		PixelToPixelCopy( From, PositionR, j, To, PositionR, j);
	}
	for( i=PositionL ; i <= PositionR ; i++ )
	{
		PixelToPixelCopy( From, i, 0, To, i, 0);
		PixelToPixelCopy( From, i, PositionB, To, i, PositionB);
	}

	// ostreni obrazu:

	for( j= PositionT+1; j <= PositionB-1 ; j++ )
	{
		PixelC = From.GetPixel(PositionL+1,j);
		PixelL = From.GetPixel(PositionL,j);

		for( i=PositionL+1 ; i <= PositionR-1 ; i++)
		{
			PixelB = From.GetPixel(i,j+1);
			PixelR = From.GetPixel(i+1,j);
			PixelT = From.GetPixel(i,j-1);
   

			tmp = PixelC.Red*Mult - PixelT.Red - PixelB.Red - PixelL.Red - PixelR.Red;
			NewPixel.Red   =  tmp>0? (tmp<255? (unsigned char)tmp:255):0;
   
			tmp = PixelC.Green*Mult - PixelT.Green - PixelB.Green - PixelL.Green - PixelR.Green;
			NewPixel.Green   =  tmp>0? (tmp<255? (unsigned char)tmp:255):0;
   
			tmp = PixelC.Blue*Mult - PixelT.Blue - PixelB.Blue - PixelL.Blue - PixelR.Blue;
			NewPixel.Blue  = tmp>0? (tmp<255? (unsigned char)tmp:255):0;
   
			NewPixel.Alpha = PixelC.Alpha;

			To.SetPixel(i,j,NewPixel);
   
			PixelL = PixelC;
			PixelC = PixelR;
		}
	}
	return;
}
//-----------------------------------------------------------------------------
