(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     11306,        334]
NotebookOptionsPosition[      9703,        299]
NotebookOutlinePosition[     10039,        314]
CellTagsIndexPosition[      9996,        311]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Slide 6/29, plotting options", "Subsection",
 CellChangeTimes->{{3.943023561459208*^9, 
  3.9430235760748043`*^9}},ExpressionUUID->"39eb5c69-b0a2-46e2-bd54-\
b52739c0d939"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"x", "^", "3"}], ",", 
     RowBox[{"x", "^", "4"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "5"}], "}"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"RGBColor", "[", 
         RowBox[{"0.9", ",", "0.1", ",", "0.2"}], "]"}], ",", "Dashed", ",", 
        "Thick"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"RGBColor", "[", 
         RowBox[{"0.1", ",", "0.9", ",", "0.3"}], "]"}], ",", 
        RowBox[{"Thickness", "[", "0.008", "]"}], ",", "Dotted"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"RGBColor", "[", 
         RowBox[{"0.2", ",", "0.3", ",", "0.95"}], "]"}], ",", "Thin", ",", 
        "DotDashed"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<f1\>\"", ",", "\"\<f2\>\"", ",", "\"\<f3\>\""}], "}"}]}], 
   ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<x axis\>\"", ",", "\"\<f(x)\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.943023586856449*^9, 3.94302358685678*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"75c94c62-0f36-45b3-8038-6f3baad642ac"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide 11/29, Applying functions repeatedly (1)", "Subsection",
 CellChangeTimes->{{3.943023674744341*^9, 
  3.943023695479981*^9}},ExpressionUUID->"f46ec6a3-dfea-4244-b56a-\
54ff5fe2e2ac"],

Cell[BoxData[{
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "3"}], " ", 
    RowBox[{"Cos", "[", "x", "]"}]}], ",", "5"}], "]"}], "\n", 
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.943023703677758*^9, 3.943023703678195*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"ba591ede-33a3-4844-a339-1ac6ffd51963"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", "4"}], ";", " ", 
  RowBox[{"n", "=", "5"}], ";", 
  RowBox[{"mtx", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "n"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"iStart", "=", "2"}], ";", 
  RowBox[{
   RowBox[{"ff", "[", 
    RowBox[{"i_", ",", "lst_List"}], "]"}], ":=", 
   RowBox[{"Part", "[", 
    RowBox[{"lst", ",", "i"}], "]"}]}], ";"}], "\n", 
 RowBox[{"FoldList", "[", 
  RowBox[{"ff", ",", "iStart", ",", "mtx"}], "]"}]}], "Input",
 CellChangeTimes->{{3.943023707826026*^9, 3.943023707826448*^9}, {
  3.943023746303811*^9, 3.943023753615543*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"291de8b7-1e88-4480-a496-aba996ff1d77"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide 11/29, Applying functions repeatedly (2)", "Subsection",
 CellChangeTimes->{{3.943023772389476*^9, 
  3.94302377418909*^9}},ExpressionUUID->"969e53f3-1a1b-4b4b-9a75-\
0d2c3fb2a93a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"s", "=", "5.0"}], ";", 
  RowBox[{"(*", 
   RowBox[{
   "number", " ", "to", " ", "take", " ", "square", " ", "root", " ", "of"}], 
   "*)"}], 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"1", "/", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{"#", "+", 
        RowBox[{"s", "/", "#"}]}], ")"}]}], "&"}], ",", "1", ",", "10"}], 
   "]"}]}], "\n", 
 RowBox[{"FixedPoint", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", "2"}], " ", 
     RowBox[{"(", 
      RowBox[{"#", "+", 
       RowBox[{"s", "/", "#"}]}], ")"}]}], "&"}], ",", "1"}], "]"}], "\n", 
 RowBox[{
  RowBox[{"Sqrt", "[", "s", "]"}], "-", "%", " ", 
  RowBox[{"(*", 
   RowBox[{
   "compare", " ", "the", " ", "result", " ", "with", " ", "the", " ", "true",
     " ", "value"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.943023781051601*^9, 3.943023781052041*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"afe9e535-898a-4d0e-b577-dc4afa4ddd90"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"alpha", "=", "0.95"}], ";", 
  RowBox[{"nOnes", "=", "100"}], ";", 
  RowBox[{"nZeros", "=", "30"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"x", "=", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{"0.0", ",", "20"}], "]"}], "~", "Join", "~", 
     RowBox[{"Table", "[", 
      RowBox[{"1.0", ",", "nOnes"}], "]"}], "~", "Join", "~", 
     RowBox[{"Table", "[", 
      RowBox[{"0.0", ",", "nZeros"}], "]"}]}]}], ";"}], "\n", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"x", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{"0", ",", "20"}], "]"}], "~", "Join", "~", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2.5"}], "/", "nOnes"}], " ", 
        RowBox[{"Range", "[", "nOnes", "]"}]}], "]"}], "~", "Join", "~", 
      RowBox[{"Table", "[", 
       RowBox[{"0", ",", "nZeros"}], "]"}]}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FoldList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"alpha", " ", "#1"}], "+", 
      RowBox[{"0.1", " ", "#2"}]}], "&"}], ",", "0", ",", "x"}], "]"}], 
  ";"}], "\n", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "%"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Large"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9430237938598137`*^9, 3.943023793860435*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"4bf6040f-2c45-40d0-a7a0-3f3e05842a5c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide 16/29, Calculus", "Subsection",
 CellChangeTimes->{{3.943023998231764*^9, 
  3.9430240040796003`*^9}},ExpressionUUID->"a11d108c-3566-4c01-bf27-\
9abf1c3ee7bc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"x", " ", 
     RowBox[{"Cos", "[", "a", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", 
     RowBox[{"2", " ", "Pi"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9430240091313*^9, 3.943024013923688*^9}, {
  3.943024048887869*^9, 3.943024052006522*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"158d7152-be7c-4622-8033-de1ed86984fb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide 18/29, Array shaping", "Subsection",
 CellChangeTimes->{{3.943024121366686*^9, 3.9430241288124*^9}, {
  3.943025607466852*^9, 
  3.9430256075452003`*^9}},ExpressionUUID->"3da00fbe-2841-442e-ad28-\
60ff77b55706"],

Cell[BoxData[{"Pi", "\n", 
 RowBox[{
  RowBox[{"First", "@", 
   RowBox[{"RealDigits", "@", 
    RowBox[{"N", "[", 
     RowBox[{"%", ",", "100"}], "]"}]}]}], 
  RowBox[{"(*", 
   RowBox[{"list", " ", "of", " ", "digits"}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"Partition", "[", 
   RowBox[{"%", ",", "7"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Transpose", "@", "%"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Grid", "[", 
   RowBox[{"%", ",", 
    RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{
   "show", " ", "the", " ", "matrix", " ", "in", " ", "a", " ", "grid"}], 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.943024143142591*^9, 3.9430241431428947`*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"0c253af8-c7c4-4eac-a9be-303af8980779"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"list", " ", "of", " ", "numbers"}], "*)"}], 
  RowBox[{
   RowBox[{"Range", "[", "24", "]"}], "\n", 
   RowBox[{"(*", 
    RowBox[{"transform", " ", "list", " ", "of", " ", "numbers"}], "*)"}], 
   RowBox[{
    RowBox[{"Partition", "[", 
     RowBox[{"%", ",", "3"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"to", " ", "list", " ", "of", " ", "matrices"}], "*)"}], " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Partition", "[", 
       RowBox[{"#", ",", "2"}], "]"}], "&"}], "@", "%"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"MatrixForm", "/@", "%"}], "\n", 
   RowBox[{"(*", 
    RowBox[{"tranpose", " ", "matrices"}], "*)"}], " ", 
   RowBox[{
    RowBox[{"Transpose", "/@", "%%"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"MatrixForm", "/@", "%"}], "\n", 
   RowBox[{"Flatten", "[", "%%", "]"}], " ", 
   RowBox[{"(*", 
    RowBox[{"read", " ", "rows"}], "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.9430241500418243`*^9, 3.943024281513736*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"861f14b3-943e-4a78-adcc-6cd00dddf855"]
}, Open  ]]
},
WindowSize->{791, 911},
WindowMargins->{{Automatic, 546}, {-94, Automatic}},
FrontEndVersion->"12.0 for Linux x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 178, 3, 55, "Subsection",ExpressionUUID->"39eb5c69-b0a2-46e2-bd54-b52739c0d939"],
Cell[761, 27, 1419, 39, 124, "Input",ExpressionUUID->"75c94c62-0f36-45b3-8038-6f3baad642ac"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2217, 71, 194, 3, 55, "Subsection",ExpressionUUID->"f46ec6a3-dfea-4244-b56a-54ff5fe2e2ac"],
Cell[2414, 76, 540, 15, 55, "Input",ExpressionUUID->"ba591ede-33a3-4844-a339-1ac6ffd51963"],
Cell[2957, 93, 817, 22, 78, "Input",ExpressionUUID->"291de8b7-1e88-4480-a496-aba996ff1d77"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3811, 120, 193, 3, 55, "Subsection",ExpressionUUID->"969e53f3-1a1b-4b4b-9a75-0d2c3fb2a93a"],
Cell[4007, 125, 999, 31, 101, "Input",ExpressionUUID->"afe9e535-898a-4d0e-b577-dc4afa4ddd90"],
Cell[5009, 158, 1556, 45, 124, "Input",ExpressionUUID->"4bf6040f-2c45-40d0-a7a0-3f3e05842a5c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6602, 208, 171, 3, 55, "Subsection",ExpressionUUID->"a11d108c-3566-4c01-bf27-9abf1c3ee7bc"],
Cell[6776, 213, 740, 19, 78, "Input",ExpressionUUID->"158d7152-be7c-4622-8033-de1ed86984fb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7553, 237, 223, 4, 55, "Subsection",ExpressionUUID->"3da00fbe-2841-442e-ad28-60ff77b55706"],
Cell[7779, 243, 774, 22, 147, "Input",ExpressionUUID->"0c253af8-c7c4-4eac-a9be-303af8980779"],
Cell[8556, 267, 1131, 29, 193, "Input",ExpressionUUID->"861f14b3-943e-4a78-adcc-6cd00dddf855"]
}, Open  ]]
}
]
*)

