(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     15150,        469]
NotebookOptionsPosition[     12996,        425]
NotebookOutlinePosition[     13332,        440]
CellTagsIndexPosition[     13289,        437]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Slide 5/31, create a matrix ", "Subsection",
 CellChangeTimes->{{3.942593077014596*^9, 
  3.942593114253622*^9}},ExpressionUUID->"6f75d95b-d9f3-4afe-86c1-\
0fcf7765dbac"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"myJoin", "=", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{"#1", ",", "#2", ",", "2"}], "]"}], "&"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"Range", "[", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "2"}], "]"}], "}"}], "~", "Join", "~", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{"0", ",", "3", ",", "2"}], "]"}], "~", "myJoin", "~", 
    RowBox[{"Table", "[", 
     RowBox[{"1", ",", "3", ",", "3"}], "]"}]}], ")"}], "~", "Join", "~", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6", ",", "7"}], "}"}], "]"}], "~", "myJoin", "~", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"RandomReal", "[", "]"}], ",", "3", ",", "2"}], "]"}]}], 
   ")"}]}], "\n", 
 RowBox[{"%", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.942593149319558*^9, 3.942593152259776*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"c89d9ea1-7a5e-4957-a996-d7d61b333863"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide 7/31, Accessing parts of matrices/expressions", "Subsection",
 CellChangeTimes->{{3.94259317740278*^9, 
  3.942593197761352*^9}},ExpressionUUID->"9428b649-58fc-4218-be32-\
ee02fd77fb4b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nMax", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"2", " ", "y"}], "+", 
        RowBox[{"3", " ", "z"}]}], ")"}], "^", "n"}], "//", "Expand"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "nMax"}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{"%", "//", "Column"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"#", "[", 
     RowBox[{"[", 
      RowBox[{"2", ";;", 
       RowBox[{"-", "2"}]}], "]"}], "]"}], "&"}], "/@", "%%"}], "//", 
  "Column"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Most", "@", 
     RowBox[{"Rest", "@", "#"}]}], "&"}], "/@", "%%%"}], "//", 
  "Column"}]}], "Input",
 CellChangeTimes->{{3.942593208013834*^9, 3.9425932080140133`*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"d7d396ba-9c9b-49c4-bd1b-f0ebab64add2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nMax", "=", "20"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"IntegerDigits", "/@", 
   RowBox[{"Round", "@", 
    RowBox[{"(", 
     RowBox[{"Pi", "^", 
      RowBox[{"Range", "[", 
       RowBox[{"7", ",", "nMax"}], "]"}]}], ")"}]}]}], ";"}], "\n", 
 RowBox[{"%", "//", "Column"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Take", "[", 
     RowBox[{"#", ",", 
      RowBox[{"-", "3"}]}], "]"}], "&"}], "/@", "%%"}], "//", 
  "Column"}], "\n", 
 RowBox[{"Last", "/@", "%%%"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Drop", "[", 
     RowBox[{"#", ",", "3"}], "]"}], "&"}], "/@", "%%%%"}], "//", 
  "Column"}]}], "Input",
 CellChangeTimes->{{3.942593216643774*^9, 3.942593216644068*^9}, {
  3.942593259807063*^9, 3.942593260501996*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"ce003a7c-94c4-4346-95a0-d1282b244bb2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide 10/31, Max, Sort", "Subsection",
 CellChangeTimes->{{3.9425932845978537`*^9, 
  3.9425932975809193`*^9}},ExpressionUUID->"f5e99be1-7e5a-4500-9f42-\
e6f71911ccdb"],

Cell[BoxData[{
 RowBox[{"SeedRandom", "[", "2024", "]"}], "\n", 
 RowBox[{
  RowBox[{"nMax", "=", "6"}], ";"}], "\n", 
 RowBox[{"matA", "=", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"nMax", ",", "4"}], "}"}]}], "]"}]}], "\n", 
 RowBox[{"%", "//", "MatrixForm"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Sort", "[", 
    RowBox[{"%%", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"#1", "[", 
        RowBox[{"[", "3", "]"}], "]"}], "<", 
       RowBox[{"#2", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], "&"}]}], "]"}], "//", 
   "MatrixForm"}], " ", 
  RowBox[{"(*", "Sort", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SortBy", "[", 
    RowBox[{"%%%", ",", "Last"}], "]"}], "//", "MatrixForm"}], " ", 
  RowBox[{"(*", "SortBy", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"MaximalBy", "[", 
   RowBox[{"%%%%", ",", 
    RowBox[{
     RowBox[{"#", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}], " ", 
  RowBox[{"(*", "MaximalBy", "*)"}]}], "\n", 
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"{", 
   RowBox[{"%%%%", ",", "%%%", ",", "%%", ",", "%"}], "}"}], " ", 
  RowBox[{"(*", 
   RowBox[{"show", " ", "outputs"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.942593306190386*^9, 3.9425933061905527`*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"9c9024d7-89f7-4786-976c-2c5a5beccd0d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide 16/31, patterns", "Subsection",
 CellChangeTimes->{
  3.9425934135764027`*^9},ExpressionUUID->"8404ee5e-7b72-4480-bae2-\
16c749863c67"],

Cell[BoxData[{
 RowBox[{"v1", "=", 
  RowBox[{"{", 
   RowBox[{"4", ",", 
    RowBox[{"{", 
     RowBox[{"1.3", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", 
      RowBox[{"-", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}], ",", 
    RowBox[{"-", "3"}], ",", 
    RowBox[{"{", 
     RowBox[{"1.", ",", 
      RowBox[{"-", "0.1"}]}], "}"}]}], "}"}]}], "\n", 
 RowBox[{
  RowBox[{"Cases", "[", 
   RowBox[{"v1", ",", "_Integer"}], "]"}], " ", 
  RowBox[{"(*", "or", "*)"}]}], "\n", 
 RowBox[{"Cases", "[", 
  RowBox[{"v1", ",", "_Integer", ",", "1"}], "]"}], "\n", 
 RowBox[{"Cases", "[", 
  RowBox[{"v1", ",", "_Integer", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9425933478542433`*^9, 3.9425933775543003`*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"ea265da1-015e-4c6f-af91-22a50f5244fc"],

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"v1", ",", 
   RowBox[{"{", 
    RowBox[{"_Real", ",", "_"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.942593389571065*^9, 3.942593389571412*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"cb814c98-8c94-4545-a41e-a8836a65e065"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide 21/31, rules", "Subsection",
 CellChangeTimes->{{3.94259342502308*^9, 
  3.942593431599155*^9}},ExpressionUUID->"3015ad31-35b7-4aa3-b62d-\
dc05eb50d368"],

Cell[BoxData[{
 RowBox[{"list1", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6", ",", "7"}], "}"}]}], "}"}]}], "\n", 
 RowBox[{"Replace", "[", 
  RowBox[{"%", ",", 
   RowBox[{
    RowBox[{"p", ":", 
     RowBox[{"{", 
      RowBox[{"_", ",", "_"}], "}"}]}], "\[RuleDelayed]", 
    RowBox[{"Norm", "@", "p"}]}], ",", 
   RowBox[{"{", "1", "}"}]}], "]"}], "\n", 
 RowBox[{"Replace", "[", 
  RowBox[{"%%", ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", 
    RowBox[{"Norm", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], "]"}]}], ",", 
   RowBox[{"{", "1", "}"}]}], "]"}], "\n", 
 RowBox[{"Replace", "[", 
  RowBox[{"%%%", ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], "]"}]}], ",", 
   RowBox[{"{", "1", "}"}]}], "]"}], "\n", 
 RowBox[{"%%%%", "/.", 
  RowBox[{
   RowBox[{"p", ":", 
    RowBox[{"{", 
     RowBox[{"_", ",", "_"}], "}"}]}], "\[RuleDelayed]", 
   RowBox[{"Norm", "@", "p"}]}]}], "\n", 
 RowBox[{"%%%%%", "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", 
   RowBox[{"Norm", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], "]"}]}]}], "\n", 
 RowBox[{"%%%%%%", "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"a", "^", "2"}], "+", 
     RowBox[{"b", "^", "2"}]}], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.9425934380172653`*^9, 3.942593438017436*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"39d8d7b5-bc27-470c-8a3c-56f55e5aab9c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide 23/31, putting constraints of patterns and rules", "Subsection",
 CellChangeTimes->{{3.9425934520547*^9, 
  3.942593468686142*^9}},ExpressionUUID->"3dc8d501-c0b3-4883-a86b-\
4f9d446f0563"],

Cell[BoxData[{
 RowBox[{"vec", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"RandomInteger", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "3"}], "}"}], "]"}], ",", "10"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rule", "=", 
   RowBox[{
    RowBox[{"x_", "/;", 
     RowBox[{"x", "<", "0"}]}], "\[RuleDelayed]", 
    RowBox[{"x", "^", "2"}]}]}], ";"}], "\n", 
 RowBox[{"vec", "/.", "rule"}]}], "Input",
 CellChangeTimes->{{3.9425934789447203`*^9, 3.942593496021658*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"e3b66413-02d2-4dbe-b11c-089794012535"],

Cell[BoxData[{
 RowBox[{"lst", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Range", "[", "4", "]"}], ",", 
    RowBox[{"RandomInteger", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}], ",", "3"}], "]"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{"0", ",", "5"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], "}"}]}], "\n", 
 RowBox[{
  RowBox[{"rule2", "=", 
   RowBox[{
    RowBox[{"x_List", "/;", 
     RowBox[{
      RowBox[{"Length", "[", "x", "]"}], ">", "3"}]}], "\[RuleDelayed]", 
    RowBox[{"Take", "[", 
     RowBox[{"x", ",", "3"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Replace", "[", 
   RowBox[{"lst", ",", "rule2", ",", "1"}], "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{"lst", "/.", 
    RowBox[{"rule2", " ", "will", " ", "not", " ", "work"}]}], 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.942593509975132*^9, 3.942593516963772*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"ab8041d0-747e-4b9b-948b-de954ffe5382"],

Cell[BoxData[{
 RowBox[{"Subsets", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "3", ",", "6", ",", "4"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}]}], "]"}], "\n", 
 RowBox[{"Cases", "[", 
  RowBox[{"%", ",", 
   RowBox[{"_", "?", "OrderedQ"}]}], "]"}], "\n", 
 RowBox[{"%%", "/.", 
  RowBox[{
   RowBox[{
    RowBox[{"l", ":", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"_", "?", "NumericQ"}], ".."}], "}"}]}], "/;", 
    RowBox[{"!", 
     RowBox[{"OrderedQ", "[", "l", "]"}]}]}], "\[RuleDelayed]", 
   "Nothing"}]}], "\n", 
 RowBox[{"Replace", "[", 
  RowBox[{"%%%", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"l", ":", "_List"}], "/;", 
     RowBox[{"!", 
      RowBox[{"OrderedQ", "[", "l", "]"}]}]}], "\[RuleDelayed]", "Nothing"}], 
   ",", 
   RowBox[{"{", "1", "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.942593526661632*^9, 3.942593526661995*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"1d743dfb-0de0-4dfe-a08f-66118ccd6121"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide 25/31, Cases, Count, Select", "Subsection",
 CellChangeTimes->{{3.942593566610083*^9, 
  3.9425935846416397`*^9}},ExpressionUUID->"dc2fc866-e444-4e50-a10b-\
5adf5e2dd7b3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "2024", "]"}], ";", 
  RowBox[{"nMax", "=", "5"}], ";"}], "\n", 
 RowBox[{"matA", "=", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"nMax", ",", "2"}], "}"}]}], "]"}]}], "\n", 
 RowBox[{"Cases", "[", 
  RowBox[{"matA", ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n1_", ",", "n2_"}], "}"}], "/;", 
    RowBox[{
     RowBox[{"n1", "-", "n2"}], "<", "3"}]}]}], "]"}], "\n", 
 RowBox[{"Select", "[", 
  RowBox[{"matA", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Part", "[", 
       RowBox[{"#", ",", "1"}], "]"}], "-", 
      RowBox[{"Part", "[", 
       RowBox[{"#", ",", "2"}], "]"}]}], "<", "3"}], "&"}]}], "]"}], "\n", 
 RowBox[{"Count", "[", 
  RowBox[{"%%%", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"7", "|", "9"}], ",", "_"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.942593592571454*^9, 3.9425935925716887`*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"3d8f998c-5b86-4233-9eb6-a43c766606cb"]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{Automatic, 464}, {-38, Automatic}},
FrontEndVersion->"12.0 for Linux x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 176, 3, 55, "Subsection",ExpressionUUID->"6f75d95b-d9f3-4afe-86c1-0fcf7765dbac"],
Cell[759, 27, 1002, 28, 101, "Input",ExpressionUUID->"c89d9ea1-7a5e-4957-a996-d7d61b333863"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1798, 60, 198, 3, 55, "Subsection",ExpressionUUID->"9428b649-58fc-4218-be32-ee02fd77fb4b"],
Cell[1999, 65, 912, 30, 124, "Input",ExpressionUUID->"d7d396ba-9c9b-49c4-bd1b-f0ebab64add2"],
Cell[2914, 97, 870, 27, 147, "Input",ExpressionUUID->"ce003a7c-94c4-4346-95a0-d1282b244bb2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3821, 129, 174, 3, 55, "Subsection",ExpressionUUID->"f5e99be1-7e5a-4500-9f42-e6f71911ccdb"],
Cell[3998, 134, 1422, 43, 193, "Input",ExpressionUUID->"9c9024d7-89f7-4786-976c-2c5a5beccd0d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5457, 182, 147, 3, 55, "Subsection",ExpressionUUID->"8404ee5e-7b72-4480-bae2-16c749863c67"],
Cell[5607, 187, 884, 25, 101, "Input",ExpressionUUID->"ea265da1-015e-4c6f-af91-22a50f5244fc"],
Cell[6494, 214, 280, 6, 31, "Input",ExpressionUUID->"cb814c98-8c94-4545-a41e-a8836a65e065"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6811, 225, 165, 3, 55, "Subsection",ExpressionUUID->"3015ad31-35b7-4aa3-b62d-dc05eb50d368"],
Cell[6979, 230, 1868, 59, 170, "Input",ExpressionUUID->"39d8d7b5-bc27-470c-8a3c-56f55e5aab9c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8884, 294, 200, 3, 55, "Subsection",ExpressionUUID->"3dc8d501-c0b3-4883-a86b-4f9d446f0563"],
Cell[9087, 299, 604, 17, 78, "Input",ExpressionUUID->"e3b66413-02d2-4dbe-b11c-089794012535"],
Cell[9694, 318, 998, 29, 101, "Input",ExpressionUUID->"ab8041d0-747e-4b9b-948b-de954ffe5382"],
Cell[10695, 349, 979, 30, 101, "Input",ExpressionUUID->"1d743dfb-0de0-4dfe-a08f-66118ccd6121"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11711, 384, 183, 3, 55, "Subsection",ExpressionUUID->"dc2fc866-e444-4e50-a10b-5adf5e2dd7b3"],
Cell[11897, 389, 1083, 33, 125, "Input",ExpressionUUID->"3d8f998c-5b86-4233-9eb6-a43c766606cb"]
}, Open  ]]
}
]
*)

