(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     17674,        540]
NotebookOptionsPosition[     15099,        490]
NotebookOutlinePosition[     15440,        505]
CellTagsIndexPosition[     15397,        502]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Slide 7/26, history of evaluated expressions", "Subsection",
 CellChangeTimes->{
  3.941992341829664*^9, {3.9419924639250793`*^9, 
   3.9419924826516943`*^9}},ExpressionUUID->"df2a3648-9da5-4804-a427-\
8761fde5efae"],

Cell[BoxData[{"5", "\n", 
 RowBox[{
  RowBox[{"Cos", "[", "%", "]"}], "^", "2"}], "\n", 
 RowBox[{"%", "-", "%%"}], "\n", 
 RowBox[{"Range", "[", 
  RowBox[{"0", ",", "1", ",", "0.5"}], "]"}], "\n", 
 RowBox[{"Range", "[", 
  RowBox[{
   RowBox[{"-", "2"}], ",", "3", ",", "1"}], "]"}], "\n", 
 RowBox[{"Outer", "[", 
  RowBox[{"Plus", ",", "%%", ",", "%"}], "]"}], "\n", 
 RowBox[{"Mean", "/@", "%"}]}], "Input",
 CellChangeTimes->{3.9419923503417997`*^9, 3.9419924915963097`*^9},
 CellLabel->"In[29]:=",ExpressionUUID->"0ed3917f-bf3e-4be0-8823-6e2d03577de4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide 9/26, ways to input expressions", "Subsection",
 CellChangeTimes->{{3.941992356416935*^9, 
  3.941992372992467*^9}},ExpressionUUID->"b27a701c-4bd8-4f7b-b8d9-\
9a8712ce5dc0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Sin", "@", "x"}], " ", 
  RowBox[{"(*", 
   RowBox[{"prefix", " ", "form"}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"x", "//", "Sin"}], " ", 
  RowBox[{"(*", 
   RowBox[{"postfix", " ", "form"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Less", "[", 
   RowBox[{"x", ",", "y"}], "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{"standard", " ", "form"}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"x", "~", "Less", "~", "y"}], " ", 
  RowBox[{"(*", 
   RowBox[{"infix", " ", "form"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"5", "^", "100"}], ",", "20"}], "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{"standard", " ", "form"}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"(", 
   RowBox[{"5", "^", "100"}], ")"}], "~", "N", "~", "20", " ", 
  RowBox[{"(*", 
   RowBox[{"infix", " ", "form"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.94199238917178*^9, 3.941992458861313*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"0cc57bf8-c760-4a84-9d87-b688be9257bb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide 13/26, properties of expressions, indexation", "Subsection",
 CellChangeTimes->{{3.941993447393257*^9, 
  3.941993469377418*^9}},ExpressionUUID->"95a00c8b-b404-4056-855b-\
e478a36e0039"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", "\"\<data\>\""}], "]"}], 
   ";"}], 
  RowBox[{"(*", 
   RowBox[{"set", " ", 
    RowBox[{"curr", ".", "dir", ".", 
     RowBox[{"to", "'"}]}], 
    RowBox[{
     RowBox[{"ntb", ".", 
      RowBox[{"dir", "'"}]}], "/", "data"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FileNames", "[", "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{
   "list", " ", "of", " ", "filenames", " ", "in", " ", "the", " ", "current",
     " ", "directory"}], "*)"}]}], "\n", 
 RowBox[{"tab01", "=", 
  RowBox[{"Import", "[", 
   RowBox[{"\"\<rec01_containers.txt\>\"", ",", "\"\<Data\>\""}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab01", "[", 
   RowBox[{"[", 
    RowBox[{";;", ",", "2"}], "]"}], "]"}], "//", "Mean"}], "\n", 
 RowBox[{
  RowBox[{"tab01", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "3"}], "]"}], "]"}], "//", 
  "Max"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab02", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<rec02_numbers.txt\>\"", ",", "\"\<Data\>\""}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"tab02ex", "=", 
  RowBox[{"tab02", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "5"}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.941993482301001*^9, 3.941993497663518*^9}, {
  3.941993619473263*^9, 3.9419936424917316`*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"6772583f-6122-455d-911b-21e0e63686a9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide 14/26, properties of expressions, indexation", "Subsection",
 CellChangeTimes->{{3.941993661337367*^9, 
  3.9419936842339983`*^9}},ExpressionUUID->"b0a665a7-63e9-422d-9b02-\
f0275490e02a"],

Cell[BoxData[{
 RowBox[{"Exp", "[", 
  RowBox[{"Cos", "[", "x", "]"}], "]"}], "\n", 
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{"pol", "=", 
  RowBox[{
   RowBox[{"%", "//", "Normal"}], "//", "Expand"}]}], "\n", 
 RowBox[{"pol", "[", 
  RowBox[{"[", 
   RowBox[{"3", ";;", "5"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.941993700574136*^9, 3.941993700574662*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"e81f8b2b-162e-405f-8da0-2ed7ccf8801a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{
    RowBox[{"5", "^", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Tan", "[", 
        RowBox[{"x", "^", "2"}], "]"}], "-", "1"}], ")"}]}], "+", 
    RowBox[{"4", " ", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"3", " ", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"x", "+", "3"}], "]"}], "^", "2"}]}], ")"}]}]}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"expr", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "2", ",", "2", ",", "1"}], "]"}], "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{"a", ")"}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"expr", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "2", ",", "2", ",", "2", ",", "1"}], "]"}], "]"}], " ", 
  
  RowBox[{"(*", 
   RowBox[{"b", ")"}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"expr", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{"c", ")"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.941993710477158*^9, 3.941993710477613*^9}, {
  3.941993740983843*^9, 3.9419937411189547`*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"b9ce45cc-78a8-4006-a775-4f8e4f3a86a3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide 16/26, Simple rules", "Subsection",
 CellChangeTimes->{{3.941993816396304*^9, 
  3.941993825476807*^9}},ExpressionUUID->"28c983ff-6906-45a4-8aea-\
e6a34a97ab91"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "x", "]"}], ";", 
  RowBox[{"sols", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"4", " ", "x"}], "-", "1"}], "\[Equal]", "0"}], ",", "x"}], 
    "]"}]}]}], "\n", 
 RowBox[{"x", "/.", "sols"}]}], "Input",
 CellChangeTimes->{{3.9419938333506737`*^9, 3.941993833351122*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"0aa57ee1-3c00-4b37-8269-777370069cc3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"x", ",", "y"}], "]"}], ";"}], "\n", 
 RowBox[{"sols", "=", 
  RowBox[{"NSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"x", " ", "y"}], "-", "1"}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "^", "2"}], "+", "x", "+", "2"}], "\[Equal]", "0"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "/.", "sols"}]}], "Input",
 CellChangeTimes->{{3.9419938395358553`*^9, 3.941993839536509*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"97b57b89-c597-4028-8f81-2405c18523e4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide 28/26, Apply and Map", "Subsection",
 CellChangeTimes->{{3.941993863052804*^9, 
  3.9419938718512173`*^9}},ExpressionUUID->"53c1ea48-bd2d-4d93-9edd-\
1e9ab43f0769"],

Cell[BoxData[{
 RowBox[{"mat", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "1", ",", 
      RowBox[{"-", "3"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "4", ",", "2"}], "}"}]}], "}"}]}], "\n", 
 RowBox[{"matT", "=", 
  RowBox[{"Transpose", "@", "%"}]}], "\n", 
 RowBox[{
  RowBox[{"Dot", "@@", "mat"}], " ", 
  RowBox[{"(*", "Dot", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"mat3D", "=", 
   RowBox[{"Outer", "[", 
    RowBox[{"List", ",", 
     RowBox[{"mat", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"mat", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], " ", 
  RowBox[{"(*", "Outer", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"%", "//", "Grid"}], ",", 
    RowBox[{"%", "//", "MatrixForm"}]}], "}"}], 
  RowBox[{"(*", 
   RowBox[{"Grid", "-", 
    RowBox[{
    "view", " ", "and", " ", "MatrixForm", " ", "from", " ", "the", " ", 
     "previous", " ", "result"}]}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"Apply", "[", 
   RowBox[{"Times", ",", "mat3D", ",", 
    RowBox[{"{", "2", "}"}]}], "]"}], " ", 
  RowBox[{"(*", "Times", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"%", "//", "Grid"}], " ", 
  RowBox[{"(*", 
   RowBox[{"Grid", "-", 
    RowBox[{
    "view", " ", "from", " ", "the", " ", "previous", " ", "result"}]}], 
   "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{"List", ",", "mat", ",", 
    RowBox[{"{", "2", "}"}]}], "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{"i", "\[Rule]", 
    RowBox[{"{", "i", "}"}]}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"Total", "/@", "matT"}], " ", 
  RowBox[{"(*", "Total", "*)"}]}], "\n", 
 RowBox[{"Plus", "@@@", "matT", " ", 
  RowBox[{"(*", "Plus", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.9419938811099997`*^9, 3.941993881110491*^9}},
 CellLabel->"In[66]:=",ExpressionUUID->"64bb5647-7bbe-43fd-a869-a4844f1ccf3d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide 20/26, Pure Functions + Simple Functions", "Subsection",
 CellChangeTimes->{{3.941993897058217*^9, 3.9419939036098747`*^9}, {
  3.941993952079302*^9, 
  3.941993958463867*^9}},ExpressionUUID->"fa83b830-2311-44de-96f1-\
234c0b8989f8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"g1", "[", "a_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"Cos", "[", "a", "]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", "a", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"Cos", "[", "a", "]"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"g3", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"Cos", "[", "#", "]"}]}], "}"}], "&"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g1", "[", "b", "]"}], ",", 
   RowBox[{"g2", "[", "b", "]"}], ",", 
   RowBox[{"g3", "[", "b", "]"}]}], "}"}]}], "Input",
 CellChangeTimes->{{3.9419939159991083`*^9, 3.94199391599958*^9}},
 CellLabel->"In[76]:=",ExpressionUUID->"7a501793-1749-4a29-a946-573e8a0f92bb"],

Cell[BoxData[
 RowBox[{"g1", "/@", "v"}]], "Input",
 CellChangeTimes->{{3.941993924668603*^9, 3.941993924669088*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"aa6581e3-a22c-44b7-836c-098532bf8360"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f5", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Max", "[", "#", "]"}], "-", 
     RowBox[{"Min", "[", "#", "]"}]}], "&"}]}], " ", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"or", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Max", "@@", "#"}], "-", 
       RowBox[{"Min", "@@", "#"}]}], ")"}]}], "&"}], "*)"}]}], "\n", 
 RowBox[{"f5", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "3"}], ",", "8", ",", "2"}], "}"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.941993931673332*^9, 3.941993931673963*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"1df5a89a-7df1-4d59-b964-02683ad35ca4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide 21/26, Pure Functions + Simple Functions (2)", "Subsection",
 CellChangeTimes->{{3.941993968024287*^9, 
  3.9419939829276457`*^9}},ExpressionUUID->"556c2e81-94f3-4d6c-9827-\
109163d95dfb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "x", "]"}], ";", 
  RowBox[{"x", "^", "2"}]}], "\n", 
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{"%", ",", "x"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", "5"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.941993985424006*^9, 3.9419939979607067`*^9}},
 CellLabel->"In[83]:=",ExpressionUUID->"3aec7abc-be1c-43df-8d32-d742d8e6d473"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tangent", "[", 
   RowBox[{"exprFx_", ",", "x0_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"exprFx", ",", "x"}], "]"}], "/.", 
      RowBox[{"x", "\[Rule]", "x0"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"x", "-", "x0"}], ")"}]}], "+", 
   RowBox[{"(", 
    RowBox[{"exprFx", "/.", 
     RowBox[{"x", "\[Rule]", "x0"}]}], ")"}]}]}], "\n", 
 RowBox[{
  RowBox[{"x", "^", "2"}], " ", 
  RowBox[{"(*", 
   RowBox[{"define", " ", "an", " ", "expression", " ", "in", " ", "x"}], 
   "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"%", ",", 
    RowBox[{"tangent", "[", 
     RowBox[{"%", ",", "1"}], "]"}], ",", 
    RowBox[{"tangent", "[", 
     RowBox[{"%", ",", "2"}], "]"}]}], "}"}], "//", "Expand", " ", 
  RowBox[{"(*", 
   RowBox[{"{", 
    RowBox[{"func", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"tang", ".", "at"}], " ", "x"}], "=", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"tang", ".", "at"}], " ", "x"}], "=", "2"}]}], "}"}], 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.941994005985702*^9, 3.9419940198493147`*^9}},
 CellLabel->"In[85]:=",ExpressionUUID->"86cd1187-b129-4f0f-9f80-b59dab952277"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tangent2", "[", 
    RowBox[{"func_", ",", "x0_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Derivative", "[", "1", "]"}], "[", "func", "]"}], "[", "x0", 
      "]"}], " ", 
     RowBox[{"(", 
      RowBox[{"x", "-", "x0"}], ")"}]}], "+", 
    RowBox[{"func", "[", "x0", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"f1", "[", "t_", "]"}], ":=", 
   RowBox[{"t", "^", "2"}]}], ";", 
  RowBox[{"(*", 
   RowBox[{"define", " ", "a", " ", "function"}], "*)"}], 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f1", "[", "x", "]"}], ",", 
     RowBox[{"tangent2", "[", 
      RowBox[{"f1", ",", "1"}], "]"}], ",", 
     RowBox[{"tangent2", "[", 
      RowBox[{"f1", ",", "2"}], "]"}]}], "}"}], "//", "Expand"}]}]}], "Input",\

 CellChangeTimes->{{3.941994033377877*^9, 3.941994033378511*^9}},
 CellLabel->"In[88]:=",ExpressionUUID->"9190f568-8d43-4d15-bc7f-6ada3798f07d"]
}, Open  ]]
},
WindowSize->{1509, 1011},
WindowMargins->{{Automatic, -1605}, {Automatic, -210}},
FrontEndVersion->"12.0 for Linux x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 222, 4, 55, "Subsection",ExpressionUUID->"df2a3648-9da5-4804-a427-8761fde5efae"],
Cell[805, 28, 560, 13, 170, "Input",ExpressionUUID->"0ed3917f-bf3e-4be0-8823-6e2d03577de4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1402, 46, 185, 3, 55, "Subsection",ExpressionUUID->"b27a701c-4bd8-4f7b-b8d9-9a8712ce5dc0"],
Cell[1590, 51, 1031, 30, 147, "Input",ExpressionUUID->"0cc57bf8-c760-4a84-9d87-b688be9257bb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2658, 86, 198, 3, 55, "Subsection",ExpressionUUID->"95a00c8b-b404-4056-855b-e478a36e0039"],
Cell[2859, 91, 1602, 49, 170, "Input",ExpressionUUID->"6772583f-6122-455d-911b-21e0e63686a9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4498, 145, 200, 3, 55, "Subsection",ExpressionUUID->"b0a665a7-63e9-422d-9b02-f0275490e02a"],
Cell[4701, 150, 562, 15, 101, "Input",ExpressionUUID->"e81f8b2b-162e-405f-8da0-2ed7ccf8801a"],
Cell[5266, 167, 1164, 38, 101, "Input",ExpressionUUID->"b9ce45cc-78a8-4006-a775-4f8e4f3a86a3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6467, 210, 173, 3, 55, "Subsection",ExpressionUUID->"28c983ff-6906-45a4-8aea-e6a34a97ab91"],
Cell[6643, 215, 482, 13, 55, "Input",ExpressionUUID->"0aa57ee1-3c00-4b37-8269-777370069cc3"],
Cell[7128, 230, 765, 23, 78, "Input",ExpressionUUID->"97b57b89-c597-4028-8f81-2405c18523e4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7930, 258, 176, 3, 55, "Subsection",ExpressionUUID->"53c1ea48-bd2d-4d93-9edd-1e9ab43f0769"],
Cell[8109, 263, 1892, 59, 239, "Input",ExpressionUUID->"64bb5647-7bbe-43fd-a869-a4844f1ccf3d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10038, 327, 245, 4, 55, "Subsection",ExpressionUUID->"fa83b830-2311-44de-96f1-234c0b8989f8"],
Cell[10286, 333, 868, 27, 101, "Input",ExpressionUUID->"7a501793-1749-4a29-a946-573e8a0f92bb"],
Cell[11157, 362, 196, 3, 31, "Input",ExpressionUUID->"aa6581e3-a22c-44b7-836c-098532bf8360"],
Cell[11356, 367, 863, 27, 55, "Input",ExpressionUUID->"1df5a89a-7df1-4d59-b964-02683ad35ca4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12256, 399, 200, 3, 55, "Subsection",ExpressionUUID->"556c2e81-94f3-4d6c-9827-109163d95dfb"],
Cell[12459, 404, 392, 10, 55, "Input",ExpressionUUID->"3aec7abc-be1c-43df-8d32-d742d8e6d473"],
Cell[12854, 416, 1249, 39, 78, "Input",ExpressionUUID->"86cd1187-b129-4f0f-9f80-b59dab952277"],
Cell[14106, 457, 977, 30, 78, "Input",ExpressionUUID->"9190f568-8d43-4d15-bc7f-6ada3798f07d"]
}, Open  ]]
}
]
*)

