(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      8174,        249]
NotebookOptionsPosition[      6542,        212]
NotebookOutlinePosition[      6876,        227]
CellTagsIndexPosition[      6833,        224]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Slide 21/33, matrix creation", "Subsection",
 CellChangeTimes->{{3.941296827501401*^9, 
  3.94129684372503*^9}},ExpressionUUID->"ac461fb2-8618-4536-a133-\
caaa9416133e"],

Cell[BoxData[{
 RowBox[{"matA", "=", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "2"}]}], "}"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"matB", "=", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.941296845464608*^9, 3.941296896405382*^9}},
 CellLabel->
  "In[473]:=",ExpressionUUID->"bf9a62ce-fc72-4e9b-b10b-fac2ec4c7208"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide  24/33, function/command Accuracy", "Subsection",
 CellChangeTimes->{{3.941296928356462*^9, 
  3.941296944364006*^9}},ExpressionUUID->"7c759f76-5bb6-4841-9626-\
906cb078fad8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a3", "=", 
   RowBox[{
    RowBox[{"-", "2"}], "/", "4"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"a4", "=", 
   RowBox[{"-", "0.5"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"a5", "=", 
   RowBox[{"-", ".50000000000000000000000000000"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Accuracy", "[", "a3", "]"}], "\n", 
 RowBox[{"Accuracy", "[", "a4", "]"}], "\n", 
 RowBox[{"Accuracy", "[", "a5", "]"}]}], "Input",
 CellChangeTimes->{{3.94129694595233*^9, 3.9412969543905582`*^9}},
 CellLabel->
  "In[475]:=",ExpressionUUID->"196643e3-fa45-4f1d-8b02-e77338edc7c5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide 25/33, \[OpenCurlyQuote]Map\[CloseCurlyQuote]ping a command over \
elements of a List", "Subsection",
 CellChangeTimes->{{3.941297114915319*^9, 
  3.941297170899807*^9}},ExpressionUUID->"27801412-3c67-4a0d-bc11-\
c93d909ce5ef"],

Cell[BoxData[{
 RowBox[{"myList", "=", 
  RowBox[{"{", 
   RowBox[{"a3", ",", "a4", ",", "a5"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"Precision", "/@", "myList"}], "\n", 
 RowBox[{"Head", "/@", "myList"}], "\n", 
 RowBox[{"FullForm", "/@", "myList"}]}], "Input",
 CellChangeTimes->{{3.94129717310989*^9, 3.941297179597734*^9}},
 CellLabel->
  "In[481]:=",ExpressionUUID->"55cb22cc-c1bd-4245-925d-408b58ce58e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide 28/33, sum of rows in a matrix", "Subsection",
 CellChangeTimes->{{3.941297956777294*^9, 
  3.9412979845314093`*^9}},ExpressionUUID->"8b8ad827-b39d-4b6c-8031-\
12b972026e07"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"matT", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", 
       RowBox[{"1", "/", "3"}], ",", 
       RowBox[{"1", "/", "4"}], ",", 
       RowBox[{"1", "/", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "7", ",", "8", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", "0.3", ",", "0.4", ",", "0.5"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "/@", "matT"}]}], "Input",
 CellChangeTimes->{{3.9412979855984373`*^9, 3.94129800690377*^9}},
 CellLabel->
  "In[485]:=",ExpressionUUID->"9ade7704-07ca-40eb-9ec2-481df046ecf4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide 29/33,  outer and inner/dot product", "Subsection",
 CellChangeTimes->{{3.941299365918234*^9, 
  3.941299389665709*^9}},ExpressionUUID->"6d76c0c9-c0e3-45af-a6ae-\
8efe11141ca2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";", 
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"u", ".", "v"}], ",", 
   RowBox[{"v", ".", "u"}]}], "}"}], "\n", 
 RowBox[{
  RowBox[{"Outer", "[", 
   RowBox[{"Times", ",", "v", ",", "u"}], "]"}], "//", "MatrixForm"}], "\n", 
 RowBox[{
  RowBox[{"Outer", "[", 
   RowBox[{"Times", ",", "u", ",", "v"}], "]"}], "//", 
  "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.941299391019834*^9, 3.941299406507073*^9}},
 CellLabel->
  "In[487]:=",ExpressionUUID->"ddf2fb1d-73b7-4ced-a25f-3519febfda00"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slide 30/33, plotting a function", "Subsection",
 CellChangeTimes->{{3.9412994627121162`*^9, 
  3.941299472880885*^9}},ExpressionUUID->"87f1bcfa-c7da-400f-bc33-\
423b3ec5954a"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"Sin", "[", "t", "]"}], "]"}], "+", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.941299485212331*^9, 3.941299485212636*^9}},
 CellLabel->
  "In[491]:=",ExpressionUUID->"cd957e1f-bcfb-49d6-85c4-8b394ef57281"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}], "+", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2.1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "10"}], "]"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"0.5", " ", "i"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", "5"}], "}"}]}], "]"}]}], "}"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<t\>\"", ",", "\"\<f(t)\>\""}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9412994736839933`*^9, 3.941299483233943*^9}},
 CellLabel->
  "In[492]:=",ExpressionUUID->"82137435-4466-4cfc-857a-af981d61e227"]
}, Open  ]]
},
WindowSize->{890, 911},
WindowMargins->{{Automatic, 269}, {0, Automatic}},
FrontEndVersion->"12.0 for Linux x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 175, 3, 55, "Subsection",ExpressionUUID->"ac461fb2-8618-4536-a133-caaa9416133e"],
Cell[758, 27, 699, 21, 55, "Input",ExpressionUUID->"bf9a62ce-fc72-4e9b-b10b-fac2ec4c7208"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1494, 53, 187, 3, 55, "Subsection",ExpressionUUID->"7c759f76-5bb6-4841-9626-906cb078fad8"],
Cell[1684, 58, 595, 17, 147, "Input",ExpressionUUID->"196643e3-fa45-4f1d-8b02-e77338edc7c5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2316, 80, 239, 4, 55, "Subsection",ExpressionUUID->"27801412-3c67-4a0d-bc11-c93d909ce5ef"],
Cell[2558, 86, 416, 9, 101, "Input",ExpressionUUID->"55cb22cc-c1bd-4245-925d-408b58ce58e9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3011, 100, 186, 3, 55, "Subsection",ExpressionUUID->"8b8ad827-b39d-4b6c-8031-12b972026e07"],
Cell[3200, 105, 686, 19, 55, "Input",ExpressionUUID->"9ade7704-07ca-40eb-9ec2-481df046ecf4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3923, 129, 189, 3, 55, "Subsection",ExpressionUUID->"6d76c0c9-c0e3-45af-a6ae-8efe11141ca2"],
Cell[4115, 134, 722, 22, 101, "Input",ExpressionUUID->"ddf2fb1d-73b7-4ced-a25f-3519febfda00"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4874, 161, 182, 3, 55, "Subsection",ExpressionUUID->"87f1bcfa-c7da-400f-bc33-423b3ec5954a"],
Cell[5059, 166, 378, 10, 31, "Input",ExpressionUUID->"cd957e1f-bcfb-49d6-85c4-8b394ef57281"],
Cell[5440, 178, 1086, 31, 78, "Input",ExpressionUUID->"82137435-4466-4cfc-857a-af981d61e227"]
}, Open  ]]
}
]
*)

