# Included display part of the Tree class definition.
# The class definition is more easily readable without it.


def _countNodes( self, node ):
    if node == None: return 0
    return 1 + self._countNodes( node.left ) + self._countNodes( node.right )

# calculates x coord = node order of in Inorder traversal
def _setXcoord( self, inode, x_coord, X, L, R ):
    if inode == -1: return x_coord
    X[inode] = self._setXcoord( L[inode], x_coord, X, L, R ) + 1
    return self._setXcoord( R[inode], X[inode], X, L, R )

def display( self ):
    nodeImagelen = 2 # no of chars occupied by the node on one line

    N = self._countNodes( self.root )
    
    # create an entire copy of the tree
    # in BFS order of the nodes
    NIL = -1
    L, R, K, X, D = [NIL]*N, [NIL]*N, [NIL]*N, [NIL]*N, [NIL]*N
    Noderef = [None]*N
    Noderef[0] = self.root
    D[0] = 0
    icurrn = 0; ifirstfree = 1 # supposing root always exists
    while icurrn < N:
        node = Noderef[icurrn]
        K[icurrn] = node.key
        if  node.left != None:
            L[icurrn] = ifirstfree;
            Noderef[ifirstfree] = node.left
            D[ifirstfree] = D[icurrn]+1
            ifirstfree += 1
        if  node.right != None:
            R[icurrn] = ifirstfree;
            Noderef[ifirstfree] = node.right
            D[ifirstfree] = D[icurrn]+1
            ifirstfree += 1
        icurrn += 1
     # tree copy created

    self._setXcoord( 0, 0, X, L, R )
    #print(L); print(R); print(K); print(X); print(D); print()

    # now for drawing
    prevDepth = -1
    prevEndX = -1
    for icurrn in range( N ):
        nodeDepth = D[icurrn]
        LbranchSize = RbranchSize = 0
        if  L[icurrn] != NIL:
            LbranchSize = ( X[icurrn] - X[L[icurrn]] )
        if  R[icurrn] != NIL:
            RbranchSize = ( X[R[icurrn]] - X[icurrn] )

        LspacesSize = ( X[icurrn] - LbranchSize) - 1  # if first on a line
        if  prevDepth == D[icurrn]:                  # not first on line
            LspacesSize -= prevEndX

        # print the node, branches, leading spaces
        if prevDepth < D[icurrn] and prevDepth > -1 : print() # next depth occupies new line

        print( " "*nodeImagelen*LspacesSize, end = '' )
        print( "_"*nodeImagelen*LbranchSize, end = ''  )
        #print( "." + ("%2d"%node.key) + node.tag+".", end = '' )
        #print( node.tag + ("%2d"%node.key), end = ''  )
        print( "" + ("%2d"%K[icurrn]), end = ''  )
        print( "_"*nodeImagelen*RbranchSize, end = ''  )

        # used in the next run of the loop:
        prevEndX = X[icurrn] + RbranchSize
        prevDepth = D[icurrn]

    print("\n"+ '-'*N*nodeImagelen) # finish the last line of the tree
    print( )

'''
      __24________
  ____42    ____15__
__25__    __87__  62
72  68    44  81


    # calculates x coord = node order of in Inorder traversal
    def setXcoord(self, node, x_coord):
        if node == None: return x_coord
        node.xcoord = self.setXcoord(node.left, x_coord) + 1
        #print(node.key, node.setXcoord)
        return self.setXcoord(node.right, node.xcoord)

    def display(self):
        self.setXcoord(self.root, 0)
        qu = queue.Queue()
        prevDepth = -1
        prevEndX = -1
        # in the queue store pairs(node, its depth)
        qu.put( (self. root, 0) )
        while not qu.empty():
            node, nodeDepth = qu.get()

            LbranchSize = RbranchSize = 0
            if node.left != None:
                LbranchSize = (node.xcoord - node.left.xcoord)
                qu.put( (node.left, nodeDepth+1) )
            if node.right != None:
                RbranchSize = (node.right.xcoord - node.xcoord)
                qu.put( (node.right, nodeDepth+1) )

            LspacesSize = (node.xcoord - LbranchSize) - 1  # if first on a line
            if prevDepth == nodeDepth:                  # not first on line
                LspacesSize -= prevEndX

            # print the node, branches, leading spaces
            if prevDepth < nodeDepth and prevDepth > -1 : print() # next depth occupies new line
            nodelen = 2
            print( " "*nodelen*LspacesSize, end = '' )
            print( "_"*nodelen*LbranchSize, end = ''  )
            #print( "." + ("%2d"%node.key) + node.tag+".", end = '' )
            #print( node.tag + ("%2d"%node.key), end = ''  )
            print( "" + ("%2d"%node.key), end = ''  )
            print( "_"*nodelen*RbranchSize, end = ''  )

            # used in the next run of the loop:
            prevEndX = node.xcoord + RbranchSize
            prevDepth = nodeDepth
        # end of queue processing

        #N = self.countNodes( self.root )
        #print("\n"+ '-'*N*nodelen) # finish the last line of the tree
        print( )
'''


